/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.example;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Example;
import org.tribuo.classification.Label;
import org.tribuo.classification.LabelFactory;
import org.tribuo.provenance.ConfiguredDataSourceProvenance;
import org.tribuo.provenance.DataSourceProvenance;

public abstract class DemoLabelDataSource
implements ConfigurableDataSource<Label> {
    protected static final LabelFactory factory = new LabelFactory();
    public static final String X1 = "X1";
    public static final String X2 = "X2";
    static final String[] FEATURE_NAMES = new String[]{"X1", "X2"};
    public static final Label FIRST_CLASS = new Label("X");
    public static final Label SECOND_CLASS = new Label("O");
    @Config(mandatory=true, description="Number of samples to generate.")
    protected int numSamples;
    @Config(mandatory=true, description="RNG seed.")
    protected long seed;
    protected Random rng;
    protected List<Example<Label>> examples;

    DemoLabelDataSource() {
    }

    DemoLabelDataSource(int numSamples, long seed) {
        this.numSamples = numSamples;
        this.seed = seed;
    }

    public void postConfig() {
        if (this.numSamples < 1) {
            throw new PropertyException("", "numSamples", "Number of samples must be positive, found " + this.numSamples);
        }
        this.rng = new Random(this.seed);
        this.examples = Collections.unmodifiableList(this.generate());
    }

    protected abstract List<Example<Label>> generate();

    public LabelFactory getOutputFactory() {
        return factory;
    }

    public DataSourceProvenance getProvenance() {
        return new DemoLabelDataSourceProvenance(this);
    }

    public Iterator<Example<Label>> iterator() {
        return this.examples.iterator();
    }

    public static final class DemoLabelDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements ConfiguredDataSourceProvenance {
        private static final long serialVersionUID = 1L;

        DemoLabelDataSourceProvenance(DemoLabelDataSource host) {
            super((Configurable)host, "DataSource");
        }

        public DemoLabelDataSourceProvenance(Map<String, Provenance> map) {
            this(DemoLabelDataSourceProvenance.extractProvenanceInfo(map));
        }

        private DemoLabelDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
        }

        static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)DemoLabelDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)DemoLabelDataSourceProvenance.class.getSimpleName())).getValue();
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, Collections.emptyMap());
        }
    }
}

