/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import net.sf.juife.OkCancelDialog;
import org.jsampler.CC;
import org.jsampler.view.std.JSInstrumentsDbTree;
import org.jsampler.view.std.StdI18n;

public class JSDbDirectoryChooser
extends OkCancelDialog
implements TreeSelectionListener {
    private JSInstrumentsDbTree instrumentsDbTree;

    public JSDbDirectoryChooser(Frame frame) {
        super(frame, StdI18n.i18n.getLabel("JSDbDirectoryChooser.title"));
        this.initDbDirectoryChooser();
    }

    public JSDbDirectoryChooser(Dialog dialog) {
        super(dialog, StdI18n.i18n.getLabel("JSDbDirectoryChooser.title"));
        this.initDbDirectoryChooser();
    }

    private void initDbDirectoryChooser() {
        this.btnOk.setEnabled(false);
        this.instrumentsDbTree = new JSInstrumentsDbTree(CC.getInstrumentsDbTreeModel());
        this.instrumentsDbTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.instrumentsDbTree);
        int n = jScrollPane.getPreferredSize().width;
        int n2 = jScrollPane.getPreferredSize().height;
        Dimension dimension = new Dimension(n > 300 ? n : 300, n2 > 200 ? n2 : 200);
        jScrollPane.setPreferredSize(dimension);
        this.setMainPane(jScrollPane);
        this.setResizable(true);
    }

    public String getSelectedDirectory() {
        return this.instrumentsDbTree.getSelectedDirectoryPath();
    }

    public void setSelectedDirectory(String string) {
        this.instrumentsDbTree.setSelectedDirectory(string);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.setCancelled(false);
        this.setVisible(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.btnOk.setEnabled(this.instrumentsDbTree.getSelectedDirectoryNode() != null);
    }
}

